/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/*
// Test/debug function to display the last error as a message
// SCRobinson.  Dec 11 '96
*/

#include "lasterr.h"

#define NUM_BUF_LEN     11

#define NON_WIN_ERR     "Non-Windows Error Message Received"
#define MSG_TITLE       "Last Win API Error"
#define ERR_FILE_NAME   "File: "
#define ERR_LINE_NUM    "\nLine: "
#define ERR_NUMBER      "\nErr. Num: "

#define LENGTH_OF_ALL_OTHER_JUNK   (sizeof(ERR_FILE_NAME) + \
                                    sizeof(ERR_LINE_NUM) + \
                                    sizeof(ERR_NUMBER) + \
                        sizeof(HELLO_BEST) + NUM_BUF_LEN + sizeof('\0'))

/*
//////////////////////////////////////////////////////////////////////////////
*/
void EXPORT DisplayLastError( PVOID pFileName,
                             ULONG uLineNumber,
                             LONG lErrNum,
                             BOOLEAN fOutputToVC
                             )
{
  
  LPVOID	lpMsgBuf = NULL;
  char * pcMsgBuff = NULL;
  DWORD	dwErrNo;
  size_t dwMsgLen = 0;
  char   cNumBuff[NUM_BUF_LEN] = "";    /* For the line number */
  DWORD   dwNumSysChars;
  int fWeMallocd = 0;
  
  /* use user's error number if passed in */
  dwErrNo = (DWORD)(lErrNum ? lErrNum: GetLastError());
  
  /* just a quick check to see if there really is an error */
  if( ERROR_SUCCESS == dwErrNo )
    return;
  
  dwNumSysChars = FormatMessage( 
    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    NULL,
    dwErrNo,
    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),  /* Default language */
    (LPTSTR) &lpMsgBuf,
    0,
    NULL 
    );
  
  if ( !lpMsgBuf )
  {
    lpMsgBuf = malloc(sizeof(NON_WIN_ERR) + 1);
    if( NULL == lpMsgBuf )
      return;
    strcpy(lpMsgBuf, NON_WIN_ERR);
    fWeMallocd = 1;
    dwNumSysChars = sizeof(NON_WIN_ERR) + 1;
  }
  
  if( pFileName )
  {
    dwMsgLen = (dwNumSysChars + strlen((char *)pFileName) + LENGTH_OF_ALL_OTHER_JUNK);
    pcMsgBuff = malloc(dwMsgLen);
    
    if( NULL == pcMsgBuff )    /* whoops ! */
      return;
    
    /* Attach filename and line number etc to system-allocated string */
    sprintf(pcMsgBuff, "\n\n%s", lpMsgBuf);
    
    sprintf(cNumBuff, "%x", dwErrNo );
    strcat(pcMsgBuff, ERR_NUMBER );
    strcat(pcMsgBuff, cNumBuff );

    strcat(pcMsgBuff, HELLO_BEST );
    strcat(pcMsgBuff, ERR_FILE_NAME );
    strcat(pcMsgBuff, (const char *)pFileName );
    
    if( uLineNumber )
    {
      sprintf( cNumBuff, "%d", uLineNumber );
      strcat( pcMsgBuff, ERR_LINE_NUM );
      strcat( pcMsgBuff, cNumBuff );
    }
  }
  else
  {
    pcMsgBuff = (PCHAR)lpMsgBuf;
  }
  
  /* Display the msg.*/
  if( fOutputToVC )
    OutputDebugString(pcMsgBuff);
  else
    MessageBox( NULL, pcMsgBuff, MSG_TITLE, MB_OK|MB_ICONINFORMATION );
  
  /* Free buffers */
  
  if ( pcMsgBuff == lpMsgBuf )  /* only free one of them */
  {
  	pcMsgBuff = NULL;
  }

  free( pcMsgBuff );
  
  if ( fWeMallocd )
  {
    free( lpMsgBuf );
  }
  else
  {
    LocalFree( lpMsgBuf );
  }
  
  return;
}
